/*
 * Decompiled with CFR 0.152.
 */
package com.android.print.sdk.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.util.Log;
import com.android.print.sdk.PrinterInstance;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Utils {
    public static Bitmap compressBitmap(Bitmap srcBitmap, int maxLength) {
        Bitmap destBitmap = null;
        try {
            double ratio;
            BitmapFactory.Options opts = new BitmapFactory.Options();
            byte[] srcBytes = Utils.bitmap2Bytes(srcBitmap);
            BitmapFactory.decodeByteArray((byte[])srcBytes, (int)0, (int)srcBytes.length, (BitmapFactory.Options)opts);
            int srcWidth = opts.outWidth;
            int srcHeight = opts.outHeight;
            int destWidth = 0;
            int destHeight = 0;
            if (srcWidth > srcHeight) {
                ratio = srcWidth / maxLength;
                destWidth = maxLength;
                destHeight = (int)((double)srcHeight / ratio);
            } else {
                ratio = srcHeight / maxLength;
                destHeight = maxLength;
                destWidth = (int)((double)srcWidth / ratio);
            }
            BitmapFactory.Options newOpts = new BitmapFactory.Options();
            newOpts.inSampleSize = (int)ratio + 1;
            newOpts.inJustDecodeBounds = false;
            newOpts.outHeight = destHeight;
            newOpts.outWidth = destWidth;
            destBitmap = BitmapFactory.decodeByteArray((byte[])srcBytes, (int)0, (int)srcBytes.length, (BitmapFactory.Options)newOpts);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return destBitmap;
    }

    public static byte[] readStream(InputStream inStream) throws Exception {
        byte[] buffer = new byte[1024];
        int len = -1;
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        while ((len = inStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, len);
        }
        byte[] data = outStream.toByteArray();
        outStream.close();
        inStream.close();
        return data;
    }

    public static Bitmap getImageFromBytes(byte[] bytes, BitmapFactory.Options opts) {
        if (bytes != null) {
            if (opts != null) {
                return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)opts);
            }
            return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
        }
        return null;
    }

    public static Bitmap zoomBitmap(Bitmap bitmap, int w, int h) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        Matrix matrix = new Matrix();
        float scaleWidth = (float)w / (float)width;
        float scaleHeight = (float)h / (float)height;
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap newBmp = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        return newBmp;
    }

    public static byte[] bitmap2Bytes(Bitmap bm) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bm.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
        return baos.toByteArray();
    }

    public static File saveFileFromBytes(byte[] b, String outputFile) {
        File file;
        block12: {
            FilterOutputStream stream = null;
            file = null;
            try {
                try {
                    file = new File(outputFile);
                    FileOutputStream fstream = new FileOutputStream(file);
                    stream = new BufferedOutputStream(fstream);
                    stream.write(b);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (stream == null) break block12;
                    try {
                        stream.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
        return file;
    }

    public static int printBitmap2File(Bitmap bitmap, String filePath) {
        File file = filePath.endsWith(".png") ? new File(filePath) : new File(String.valueOf(filePath) + ".png");
        try {
            FileOutputStream fos = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fos);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    public static byte[] bitmap2PrinterBytes(Bitmap bitmap, int left) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        byte[] imgbuf = new byte[(width / 8 + left + 4) * height];
        byte[] bitbuf = new byte[width / 8];
        int[] p = new int[8];
        int s = 0;
        System.out.println("+++++++++++++++ Total Bytes: " + (width / 8 + 4) * height);
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width / 8) {
                int m = 0;
                while (m < 8) {
                    p[m] = bitmap.getPixel(x * 8 + m, y) == -1 ? 0 : 1;
                    ++m;
                }
                int value = p[0] * 128 + p[1] * 64 + p[2] * 32 + p[3] * 16 + p[4] * 8 + p[5] * 4 + p[6] * 2 + p[7];
                bitbuf[x] = (byte)value;
                ++x;
            }
            if (y != 0) {
                imgbuf[++s] = 22;
            } else {
                imgbuf[s] = 22;
            }
            imgbuf[++s] = (byte)(width / 8 + left);
            int j = 0;
            while (j < left) {
                imgbuf[++s] = 0;
                ++j;
            }
            int n = 0;
            while (n < width / 8) {
                imgbuf[++s] = bitbuf[n];
                ++n;
            }
            imgbuf[++s] = 21;
            imgbuf[++s] = 1;
            ++y;
        }
        return imgbuf;
    }

    public static byte[] bitmap2PrinterBytes_stylus(Bitmap bitmap, int multiple, int left) {
        byte[] imgBuf;
        int height = bitmap.getHeight();
        int width = bitmap.getWidth() + left;
        boolean need_0a = false;
        int maxWidth = 240;
        if (width < maxWidth) {
            imgBuf = new byte[(height / 8 + 1) * (width + 6)];
            need_0a = true;
        } else {
            imgBuf = new byte[(height / 8 + 1) * (width + 5) + 2];
        }
        byte[] tmpBuf = new byte[width + 5];
        int[] p = new int[8];
        int s = 0;
        int t = 0;
        boolean allZERO = true;
        int y = 0;
        while (y < height / 8 + 1) {
            t = 0;
            tmpBuf[t] = 27;
            tmpBuf[++t] = 42;
            tmpBuf[++t] = (byte)multiple;
            tmpBuf[++t] = (byte)(width % maxWidth);
            tmpBuf[++t] = (byte)(width / maxWidth > 0 ? 1 : 0);
            allZERO = true;
            int x = 0;
            while (x < width) {
                int m = 0;
                while (m < 8) {
                    p[m] = y * 8 + m >= height || x < left ? 0 : (bitmap.getPixel(x - left, y * 8 + m) == -1 ? 0 : 1);
                    ++m;
                }
                int value = p[0] * 128 + p[1] * 64 + p[2] * 32 + p[3] * 16 + p[4] * 8 + p[5] * 4 + p[6] * 2 + p[7];
                tmpBuf[++t] = (byte)value;
                if (value != 0) {
                    allZERO = false;
                }
                ++x;
            }
            if (allZERO) {
                if (s == 0) {
                    imgBuf[s] = 27;
                } else {
                    imgBuf[++s] = 27;
                }
                imgBuf[++s] = 74;
                imgBuf[++s] = 8;
            } else {
                int i = 0;
                while (i < t + 1) {
                    if (i == 0 && s == 0) {
                        imgBuf[s] = tmpBuf[i];
                    } else {
                        imgBuf[++s] = tmpBuf[i];
                    }
                    ++i;
                }
                if (need_0a) {
                    imgBuf[++s] = 10;
                }
            }
            ++y;
        }
        if (!need_0a) {
            imgBuf[++s] = 13;
            imgBuf[++s] = 10;
        }
        byte[] realBuf = new byte[s + 1];
        int i = 0;
        while (i < s + 1) {
            realBuf[i] = imgBuf[i];
            ++i;
        }
        StringBuffer sb = new StringBuffer();
        int i2 = 0;
        while (i2 < realBuf.length) {
            String temp = Integer.toHexString(realBuf[i2] & 0xFF);
            if (temp.length() == 1) {
                temp = "0" + temp;
            }
            sb.append(String.valueOf(temp) + " ");
            if (i2 != 0 && i2 % 100 == 0 || i2 == realBuf.length - 1) {
                Log.e((String)"12345", (String)sb.toString());
                sb = new StringBuffer();
            }
            ++i2;
        }
        return realBuf;
    }

    public static int getStringCharacterLength(String line) {
        int length = 0;
        int j = 0;
        while (j < line.length()) {
            length = line.charAt(j) > '\u0100' ? (length += 2) : ++length;
            ++j;
        }
        return length;
    }

    public static int getSubLength(String line, int width) {
        int length = 0;
        int j = 0;
        while (j < line.length()) {
            length = line.charAt(j) > '\u0100' ? (length += 2) : ++length;
            if (length > width) {
                int temp = line.substring(0, j - 1).lastIndexOf(" ");
                if (temp != -1) {
                    return temp;
                }
                return j - 1 == 0 ? 1 : j - 1;
            }
            ++j;
        }
        return line.length();
    }

    public static boolean isNum(byte temp) {
        return temp >= 48 && temp <= 57;
    }

    public static void Log(String tag, String msg) {
        if (PrinterInstance.DEBUG) {
            Log.i((String)tag, (String)msg);
        }
    }
}

